package gov.va.med.mhv.integration.phr.api.jackson;

import java.util.Date;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * @author K Graham
 * 
 *         The purpose of this class is to create an object mapper that won't
 *         error out in the event that a new property is introduced in an object
 *         being deserialized.
 * 
 */
public class MhvIgnoreUnknownPropertiesObjectMapper extends ObjectMapper {

	private static final long serialVersionUID = -5809594231306337499L;

	public MhvIgnoreUnknownPropertiesObjectMapper() {
		disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

		final SimpleModule module = new SimpleModule("MhvDateDeserializer", Version.unknownVersion());
		module.addDeserializer(Date.class, new MhvDateDeserializer());
		this.registerModule(module);
	}

}
